---
title: Lecture 53：常数项级数
tags:
  - 数学
  - 无穷级数
categories: 
date: 2024-02-12
---
**本章内容**
+ 第一节：常数项级数
+ 第二节：幂级数
+ 第三节：傅里叶级数

**本节内容概要**
+ (一) 级数的概念与性质
+ (二) 级数的审敛准则

**常考题型与典型例题**
+ 常数项级数敛散性的判定
---
## 47.1 常数项级数基本概念
### 47.1.1 基础概念
##### **定义**： #常数项级数
> <font color="#ccc1d9">描述：</font> $$\sum_{n=1}^\infty u_n=u_1+u_2+\cdots+u_n+\cdots $$

**解释**
+ 概念：
	+ 常数项级数表示有无穷项，每一项都是常数；
	+ 因为是无穷项，所以常数项级数就是**有无穷项个常数**的常数项级数；
	+ 用 $u_{1}, u_{2},\cdots u_{n},\cdots$ 表示，$u_{n}$ 表示一般项；
	+ 无穷项和，是使用有限项和（部分和）取极限而得到的；
+ 相加求和：
	+ $\sum_{i=1}^{\infty}u_{i}=u_{1}+u_{2}+\cdots+u_{n}$；
+ 部分和
	+ 表示前 n 项的和；
	+ $S_{n}=u_{1}+u_{2}+\cdots+u_{n}$；

##### **定义**： #常数项级数收敛
> <font color="#ccc1d9">描述：</font> $u_{1}, u_{2},\cdots u_{n},\cdots$ 表示常数项，$S_{n}=u_{1}+u_{2}+\cdots+u_{n}$ 表示前 `n` 项的和；
> 若：
>  $$\lim_{n\to+\infty}S_{n}=\sum_{n=1}^\infty u_n$$
> 则当前常数项数列为收敛的，若是没有极限，则是为发散的；

**解释**
+ 两个问题：
	+ 敛散性 `->` 极限是否存在 `<-` 这个问题更为核心；
	+ 级数的值 `->` 极限的值；

**等比数列分析**：$a+aq+aq^{2}+aq^{3}+\cdots+aq^{n-1}...$ ，等比数列，a 不等于 0，求其收敛性质；
+ 当 q 不等于 1 时，$S_{n}=\frac{a(1-q^{n})}{1-q}$
	+ 当 q 小于 1 时，此时其极限即为 0 -> 收敛；
	+ 当 q 大于 1 时，此时其极限不存在 -> 发散；
+ 如果 q 等于 1
	+ 若 `q=1`，则 $a+a+a+\cdots$，无穷个 a 相加为无限，因此发散；
	+ 若 `q=-1`，则 $a-a+a-a+a-a+\cdots$
		+ 奇数项 `->` 极限为 a；
		+ 偶数项 `->` 极限为 0；
		+ 所以极限不存在 `->` 发散；

### 47.1.2 级数的性质 
**基本性质**
+ 性质 1： $$如果\sum_{n=1}^{\infty}u_n 收敛于S，则\sum_{i=1}^{\infty}k u_n. 收敛于 kS$$
+ 性质 2：
	+ $$如果\sum_{n=1}^{\infty}H_{n}和\sum_{n=1}^{\infty}U_{n}分别收敛于 h 和 u，则\sum_{n=1}^{\infty}(H_{n}\pm U_{n})也收敛于h+u$$
	+ 两个收敛的级数，相加或相减后仍然收敛；
	+ 两个发散的级数，相加或相减后收敛性不确定；
	+ 两个相加减后收敛的级数，原本的级数未必是收敛的；
	+ 比如：
		+ $1+1+1+1...$ 和 $-1-1-1-1-1...$
		+ 相加后：$(1-1)+(1-1)+(1-1)....$
+ 性质 3：
	+ 在级数中去掉或加上**有限项**，敛散性不变，值可能会变化；
+ 性质 4：
	+ $$\sum u_n收敛，任意加括号后级数也收敛，且和不变$$
	+ 比如：
		+ $u_{1}+u_{2}+u_{3}+u_{2}+u_{5}+u_{8}+u_{7}+u_{8}+......$
		+ $S_{1},S_{2},S_{3},S_{4},S_{5},S_{6},S_{7},S_{8}......$
		+ 然后加括号：$(u_{1}+u_{2})+u_{3}+(u_{4}+u_{3})+(u_{6}+u_{7}+u_{8})+\cdots$
		+ 括号的部分合并为：$v_{1}+v_{2}+v_{3}+v_{4}+\cdots$
	+ 注意：
		+ 1. **加括号后收敛，原级数未必收敛**；
		+ 2. 加括号后发散的，原级数一定发散；
+ 性质 5：级数收敛的必要条件 
	+ $$\sum_{n=1}^\infty u_n\text{ 收敛 }\longrightarrow\lim_{n\to\infty}u_n=0$$ 
	+ 注意：
		+ $u_n$ 趋于 0，级数未必收敛.，所以是必要条件而非充要条件；
		+ 比如调和级数为发散：$1+\frac{1}{2}+\frac{1}{3}+\cdots+\frac{1}{n}+\cdots$；

## 47.2 级数分类
**分类**
+ 同号级数
	+ 正项级数 `->` [[Lecture 48：正项级数及其审敛准则]]
	+ 负项级数：就是正项级数的基础上、加一个负号；
+ 变号级数：
	+ 特殊的变号级数：交错级数 `->` [[Lecture 49：交错级数与任意项级数]]
	+ 一般的变号级数：任意项级数 `->` [[Lecture 49：交错级数与任意项级数]]


---
### 题型： #常数项级数敛散性判定 
#### PART 1：解题方法
**解题步骤**
+ 第一步：判断级数类型
	+ 正项、交错、任意项
+ 第二步：根据级数，选择方法
	+ 正项级数 `->` 用敛散性的五类判别法，做判定；
	+ 交错级数 `->` 一个方法；
	+ 任意项级数 `->` 一个方法；
+ 第三步：如果无法做出判定，此时可以使用定义和性质来进行判定
	+ 定义和性质是适用于所有类型的级数的；

**解题方法**
+ 考试的时候通常是考选择题，更建议使用直接法：找到对的选项，说明它对，而不是使用排除法、一个个找反例证明其他选项错；
+ 如何找：对当前选项，如果是错的，直接进入下一个；如果不清楚对错的，也先进入下一个，可能正确的就在后背；

**常用结论**
+ $$\sum_{n=1}^{+\infty}|b_{n|}收敛\rightarrow \sum_{n=1}^{+\infty}(b_{n})^{2}收敛$$

#### PART 2：典型例题

#### PART 3：知识点复盘